* Title: 	figure17.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of change in never married rate


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure17, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip PrimeMaleD MaritalI EmploymentI wtsupp ///
	using dta/asec_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (2) Construct rates for employment categories
*******************************************************************************

gen 	NeverMarried = (MaritalI == 1)
rename 	PrimeMaleD Total
foreach var in NeverMarried Total {
	gen `var'_Emp	= `var' if (EmploymentI == 0)
	gen `var'_ST	= `var' if (EmploymentI == 1)
	gen `var'_LT	= `var' if (EmploymentI == 2)
}
drop NeverMarried Total

collapse (sum) Total* NeverMarried* [pw=wtsupp], by(year)
	
tsset year
foreach emp in Emp ST LT {
	gen NeverMarriedRate_`emp' = 100 * (L.NeverMarried_`emp' + NeverMarried_`emp' + F.NeverMarried_`emp') ///
									 / (L.Total_`emp' + Total_`emp' + F.Total_`emp')
}

keep year NeverMarriedRate_* 
keep if (year >= 1978 & year <= 2015)

* Save dataset
compress
save output/figures/dta/figure17.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

line 	NeverMarriedRate_Emp NeverMarriedRate_ST NeverMarriedRate_LT year, ///
		legend(label(1 "Employed") label(2 "Short-term not working") label(3 "Long-term not working")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Year") ytitle("Share of men by employment status, percent")

graph save output/figures/gph/figure17, replace
graph export output/figures/eps/figure17.eps, as(eps) replace
export excel using output/figures/xlsx/figure17.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
